/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.configurations;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class JWTSessionManagement {
    private String jwtSecret = "RgQk3K9mUbBy7DnX1uO7jCjpRla1Ws97hWqj5+OShQc=";
    private long jwtExpirationMs = 108000000000L;
    byte[] bytes = (byte[])Decoders.BASE64.decode((Object)this.jwtSecret);
    Key secretKey = Keys.hmacShaKeyFor((byte[])this.bytes);

    public String generateToken(String username) {
        return Jwts.builder().setSubject(username).setIssuedAt(new Date()).setExpiration(new Date(new Date().getTime() + this.jwtExpirationMs)).signWith(this.secretKey, SignatureAlgorithm.HS256).compact();
    }

    public String getUsernameFromToken(String token) {
        return ((Claims)Jwts.parserBuilder().setSigningKey(this.secretKey).build().parseClaimsJws(token).getBody()).getSubject();
    }

    public boolean validateJwtToken(String token) {
        try {
            Jwts.parserBuilder().setSigningKey(this.secretKey).build().parseClaimsJws(token);
            return true;
        }
        catch (SecurityException e) {
            System.out.println("Invalid JWT signature: " + e.getMessage());
        }
        catch (MalformedJwtException e) {
            System.out.println("Invalid JWT token: " + e.getMessage());
        }
        catch (ExpiredJwtException e) {
            System.out.println("JWT token is expired: " + e.getMessage());
        }
        catch (UnsupportedJwtException e) {
            System.out.println("JWT token is unsupported: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.out.println("JWT claims string is empty: " + e.getMessage());
        }
        return false;
    }
}

