/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.controller;

import com.example.clinic.dto.LabReportsDTO;
import com.example.clinic.service.PateintMedicineService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
public class AddLabReport {
    @Autowired
    PateintMedicineService pateintMedicineService;

    @PostMapping(value={"/add/lab/report"})
    public ResponseEntity<?> addRLabReport(@RequestBody LabReportsDTO labReportsList) throws Exception {
        this.pateintMedicineService.addLabReport(labReportsList);
        return ResponseEntity.ok((Object)"reports added");
    }

    @DeleteMapping(value={"/delete/lab/report/{reportId}"})
    public ResponseEntity<?> deleteReports(@PathVariable(value="reportId") int reportId) throws Exception {
        this.pateintMedicineService.deleteReport(reportId);
        return ResponseEntity.ok((Object)"reports deleted");
    }

    @PostMapping(value={"labs/filter"})
    public ResponseEntity<?> labsFilter(@RequestBody LabReportsDTO labReportsDTO) throws Exception {
        List labReports = this.pateintMedicineService.filterLabs(labReportsDTO);
        return ResponseEntity.ok((Object)labReports);
    }

    @GetMapping(value={"labs/reports"})
    public ResponseEntity<?> labsReports() throws Exception {
        List labReports = this.pateintMedicineService.getReportsByUserId();
        return ResponseEntity.ok((Object)labReports);
    }
}

