/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.controller;

import com.example.clinic.configurations.JWTSessionManagement;
import com.example.clinic.dto.CredentialsRequest;
import com.example.clinic.dto.LoginReponse;
import com.example.clinic.dto.OTPBody;
import com.example.clinic.dto.UserCreateRequest;
import com.example.clinic.dto.VerificationBody;
import com.example.clinic.model.OTPValidation;
import com.example.clinic.model.User;
import com.example.clinic.model.UserSession;
import com.example.clinic.repository.UserRepository;
import com.example.clinic.service.CustomUserDetailsService;
import com.example.clinic.service.LoginServices;
import com.example.clinic.service.RegisterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@CrossOrigin
public class LoginController {
    @Autowired
    private CustomUserDetailsService userDetailsService;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private JWTSessionManagement tokenManager;
    @Autowired
    LoginServices loginServices;
    @Autowired
    UserRepository userRepository;
    @Autowired
    RegisterService registerService;

    @PostMapping(value={"/login"})
    public ResponseEntity<?> login(@RequestBody CredentialsRequest studentCreateRequest) throws Exception {
        try {
            this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)studentCreateRequest.getEmailAddress(), (Object)studentCreateRequest.getPassword()));
        }
        catch (DisabledException e) {
            throw new Exception("USER_DISABLED", e);
        }
        catch (BadCredentialsException e) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "WRONG PASSWORD");
        }
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(studentCreateRequest.getEmailAddress());
        String jwtToken = this.tokenManager.generateToken(userDetails.getUsername());
        studentCreateRequest.setToken(jwtToken);
        User user = (User)this.userRepository.findByemailAddress(studentCreateRequest.getEmailAddress()).get();
        studentCreateRequest.setUserId(user.getId());
        LoginReponse res = new LoginReponse();
        UserSession userSession = this.loginServices.loginProcess(studentCreateRequest);
        res.setSessionId(userSession.getSessionId());
        res.setUserId(user.getId());
        res.setToken(jwtToken);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/logout/user"})
    public ResponseEntity<?> logout() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        this.loginServices.logout(authentication.getName());
        return ResponseEntity.ok((Object)"Student LoggedOut  Successfully");
    }

    @PostMapping(value={"/register"})
    public ResponseEntity<?> registerUser(@RequestBody UserCreateRequest userCreateRequest) {
        User createdUser = this.registerService.addUser(userCreateRequest);
        return ResponseEntity.ok((Object)createdUser);
    }

    @GetMapping(value={"/otp/request/{phoneNumber}"})
    public ResponseEntity<?> otpReuest(@PathVariable String phoneNumber) {
        this.registerService.sendOtp(phoneNumber);
        return ResponseEntity.ok((Object)("OTP sent to Phone =>  " + phoneNumber));
    }

    @PostMapping(value={"/otp/verify"})
    public ResponseEntity<?> verifyOTP(@RequestBody VerificationBody verificationBody) {
        boolean result = this.registerService.verifyOtp(verificationBody);
        if (result) {
            return ResponseEntity.ok((Object)"OTP verified");
        }
        throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "OTP is not Valid ");
    }

    @PutMapping(value={"/edit/password"})
    public ResponseEntity<?> updatepassword(@RequestBody OTPBody otpBody) {
        this.registerService.editPassword(otpBody);
        return ResponseEntity.ok((Object)"Password changed Successfully");
    }

    @PostMapping(value={"/send/edit/password/otp"})
    public ResponseEntity<?> sendUpdatepasswordOTP(@RequestParam(value="email") String emailAdress) {
        this.loginServices.verifyEmail(emailAdress);
        return ResponseEntity.ok((Object)"email sent successfully");
    }

    @PostMapping(value={"/verify/mail/otp"})
    public OTPValidation verifyEmailOtp(@RequestBody OTPBody otpBody) {
        return this.registerService.verifyOTPEditPassword(otpBody);
    }

    @GetMapping(value={"get/user/{userId}/profile"})
    public ResponseEntity<?> getUserProfile(@PathVariable(value="userId") int userId) {
        return ResponseEntity.ok((Object)this.registerService.getProfileofUser(userId));
    }

    @DeleteMapping(value={"delete/user"})
    public ResponseEntity<?> deleteUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User user = this.userRepository.getUserByEmail(authentication.getName());
        this.userRepository.deleteUserAccount(user.getId());
        return ResponseEntity.ok((Object)"user Deleted");
    }
}

