/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.controller;

import com.example.clinic.dto.PatientMedicineDTO;
import com.example.clinic.model.PatientMedicine;
import com.example.clinic.service.PateintMedicineService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
public class MedicineController {
    @Autowired
    PateintMedicineService pateintMedicineService;

    @GetMapping(value={"get/medicine/saved"})
    public ResponseEntity<?> getMedicineSavedList() {
        List patientMedicine = this.pateintMedicineService.getMedicinListSaved();
        return ResponseEntity.ok((Object)patientMedicine);
    }

    @GetMapping(value={"get/medicine/saved/{name}"})
    public ResponseEntity<?> getMedicineSavedByName(@PathVariable(value="name") String name) {
        List patientMedicine = this.pateintMedicineService.getMedicinListSavedByname(name);
        return ResponseEntity.ok((Object)patientMedicine);
    }

    @PostMapping(value={"add/medicine"})
    public ResponseEntity<?> addMedicine(@RequestBody PatientMedicineDTO patientMedicineDTO) {
        PatientMedicine patientMedicine = this.pateintMedicineService.addMedicine(patientMedicineDTO);
        return ResponseEntity.ok((Object)patientMedicine);
    }

    @PutMapping(value={"check/done/{id}"})
    public ResponseEntity<?> checkDoneDose(@PathVariable int id) {
        PatientMedicine patientMedicine = this.pateintMedicineService.updateDoseCount(id);
        return ResponseEntity.ok((Object)patientMedicine);
    }

    @GetMapping(value={"get/medicine/list"})
    public ResponseEntity<?> getMedicinList() {
        List patientMedicine = this.pateintMedicineService.getMedicinList();
        return ResponseEntity.ok((Object)patientMedicine);
    }

    @GetMapping(value={"medicine/details/{id}"})
    public ResponseEntity<?> getMediicneDetails(@PathVariable int id) {
        PatientMedicine patientMedicine = this.pateintMedicineService.getMedicineDetails(id);
        return ResponseEntity.ok((Object)patientMedicine);
    }

    @DeleteMapping(value={"remove/medicine/{id}"})
    public ResponseEntity<?> deleteMedicine(@PathVariable int id) {
        this.pateintMedicineService.deleteMedicine(id);
        return ResponseEntity.ok((Object)("Medicine removed id " + id));
    }

    @PostMapping(value={"renew/medicine/{id}"})
    public ResponseEntity<?> renewMedicine(@PathVariable int id) {
        this.pateintMedicineService.renewMedicine(id);
        return ResponseEntity.ok((Object)"Medicine renewed to new Duration ");
    }

    @PutMapping(value={"update/medicine/{id}"})
    public ResponseEntity<?> updateMedicine(@PathVariable int id, @RequestBody PatientMedicineDTO patientMedicineDTO) {
        this.pateintMedicineService.updateMedicine(id, patientMedicineDTO);
        return ResponseEntity.ok((Object)"Medicine Updated to new Data ");
    }
}

