/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.filter;

import com.example.clinic.configurations.JWTSessionManagement;
import com.example.clinic.model.UserSession;
import com.example.clinic.service.CustomUserDetailsService;
import io.jsonwebtoken.ExpiredJwtException;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtFilter
extends OncePerRequestFilter {
    @Autowired
    private CustomUserDetailsService userDetailsService;
    @Autowired
    private JWTSessionManagement tokenManager;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException, HttpClientErrorException.Unauthorized {
        HttpServletRequest requestUrl = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String tokenHeader = null;
        if (!(requestUrl.getRequestURL().toString().contains("/login") || requestUrl.getRequestURL().toString().contains("/register") || requestUrl.getRequestURL().toString().contains("/otp/verify") || requestUrl.getRequestURL().toString().contains("/otp/request") || requestUrl.getRequestURL().toString().contains("/verify/mail/otp") || requestUrl.getRequestURL().toString().contains("/send/edit/password/otp") || requestUrl.getRequestURL().toString().contains("/edit/password") || requestUrl.getRequestURL().toString().contains("/onboard/view") || requestUrl.getRequestURL().toString().contains("/edit/password"))) {
            tokenHeader = request.getHeader("Authorization");
            if (tokenHeader == null || tokenHeader.isEmpty()) {
                response.setStatus(HttpStatus.UNAUTHORIZED.value());
                response.getWriter().write("Token is not Found");
                response.setContentType("application/json");
                return;
            }
            String username = null;
            String token = null;
            Optional tokenDB = null;
            tokenDB = tokenHeader != null && tokenHeader.contains("Bearer") ? this.userDetailsService.getTokenByName(tokenHeader.split(" ")[1]) : Optional.empty();
            if (!tokenHeader.contains("Bearer")) {
                response.setStatus(401);
                response.getWriter().write("Token is in not valid format with no bearer");
                response.setContentType("application/json");
                return;
            }
            if (tokenDB == null || !tokenDB.isPresent()) {
                response.setStatus(401);
                response.getWriter().write("Token is not Found");
                response.setContentType("application/json");
                return;
            }
            if (!tokenHeader.split(" ")[1].equals(((UserSession)tokenDB.get()).getToken())) {
                response.setStatus(401);
                response.getWriter().write("Token is not valid");
                response.setContentType("application/json");
                return;
            }
            if (tokenHeader != null && tokenHeader.startsWith("Bearer ")) {
                token = tokenHeader.substring(7);
                try {
                    username = this.tokenManager.getUsernameFromToken(token);
                }
                catch (IllegalArgumentException e) {
                    response.setStatus(401);
                    response.getWriter().write("Token is not Correct");
                    response.setContentType("application/json");
                    return;
                }
                catch (ExpiredJwtException e) {
                    response.setStatus(401);
                    response.getWriter().write("Token is  Expired");
                    response.setContentType("application/json");
                    return;
                }
            } else {
                response.setStatus(401);
                response.getWriter().write("Token is not valid with bearer");
                response.setContentType("application/json");
                return;
            }
            if (null != username && SecurityContextHolder.getContext().getAuthentication() == null) {
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
                if (this.tokenManager.validateJwtToken(token)) {
                    UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                    authenticationToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                    SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
                }
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

