/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.repository.impl;

import com.example.clinic.model.BloodPressure;
import com.example.clinic.model.BloodRate;
import com.example.clinic.model.BloodSugarRandom;
import com.example.clinic.model.FluidBalance;
import com.example.clinic.model.Images;
import com.example.clinic.model.OxygenSaturation;
import com.example.clinic.model.PatientUploadedFiles;
import com.example.clinic.model.Weight;
import com.example.clinic.repository.OverViewRepository;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@Transactional
public class OverViewRepositoryImpl
implements OverViewRepository {
    @Autowired
    EntityManager em;

    public void addBloodPressure(BloodPressure bloodPressure) {
        this.em.merge((Object)bloodPressure);
    }

    public void addBloodRate(BloodRate bloodRate) {
        this.em.merge((Object)bloodRate);
    }

    public void addOxygenSaturation(OxygenSaturation oxygenSaturation) {
        this.em.merge((Object)oxygenSaturation);
    }

    public void addWeight(Weight weight) {
        this.em.merge((Object)weight);
    }

    public void addBloodSugarRandom(BloodSugarRandom bloodSugarRandom) {
        this.em.merge((Object)bloodSugarRandom);
    }

    public void addFluidBalance(FluidBalance fluidBalance) {
        this.em.merge((Object)fluidBalance);
    }

    public Object getbloodPressureByDBP(int dbp) {
        TypedQuery query = this.em.createQuery("select m from BloodPressure m JOIN FETCH m.user u where u.id = :id", Object.class);
        query.setParameter("id", (Object)dbp);
        return query.getResultList();
    }

    public Object getHeartRate(int id) {
        TypedQuery query = this.em.createQuery("select m from BloodRate m JOIN FETCH m.user u where u.id = :id", Object.class);
        query.setParameter("id", (Object)id);
        return query.getResultList();
    }

    public Object getOxygenSaturation(int id) {
        TypedQuery query = this.em.createQuery("select m from OxygenSaturation m JOIN FETCH m.user u where u.id = :id", Object.class);
        query.setParameter("id", (Object)id);
        return query.getResultList();
    }

    public Object getBloodSugarLevel(int id) {
        TypedQuery query = this.em.createQuery("select m from BloodSugarRandom m JOIN FETCH m.user u where u.id = :id", Object.class);
        query.setParameter("id", (Object)id);
        return query.getResultList();
    }

    public Object getFluidRange(int id) {
        TypedQuery query = this.em.createQuery("select m from FluidBalance m JOIN FETCH m.user u where u.id = :id", Object.class);
        query.setParameter("id", (Object)id);
        return query.getResultList();
    }

    public Object getWeight(int id) {
        TypedQuery query = this.em.createQuery("select m from Weight m JOIN FETCH m.user u where u.id = :id", Object.class);
        query.setParameter("id", (Object)id);
        return query.getResultList();
    }

    public PatientUploadedFiles addImages(PatientUploadedFiles images) {
        return (PatientUploadedFiles)this.em.merge((Object)images);
    }

    public List<PatientUploadedFiles> getPatientFilesByDateFroAndTo(int id, String dateFrom, String dateTo) {
        TypedQuery query = this.em.createQuery("select m from PatientUploadedFiles m JOIN FETCH m.userFiles u where u.id = :id  And m.date Between :fromDate AND :toDate ", PatientUploadedFiles.class);
        query.setParameter("id", (Object)id);
        query.setParameter("fromDate", (Object)dateFrom);
        query.setParameter("toDate", (Object)dateTo);
        return query.getResultList();
    }

    public List<PatientUploadedFiles> getPatientFilesByDesc(int id) {
        TypedQuery query = this.em.createQuery("select m from PatientUploadedFiles m JOIN FETCH m.userFiles u where u.id = :id order by m.id desc", PatientUploadedFiles.class);
        query.setParameter("id", (Object)id);
        return query.getResultList();
    }

    public List<PatientUploadedFiles> getPatientFilesByAsc(int id) {
        TypedQuery query = this.em.createQuery("select m from PatientUploadedFiles m JOIN FETCH m.userFiles u where u.id = :id order by m.id asc", PatientUploadedFiles.class);
        query.setParameter("id", (Object)id);
        return query.getResultList();
    }

    public List<PatientUploadedFiles> getPatientFilesByType(int id, String type) {
        TypedQuery query = this.em.createQuery("select m from PatientUploadedFiles m JOIN FETCH m.userFiles u where u.id = :id AND m.folderName = :folderName ", PatientUploadedFiles.class);
        query.setParameter("id", (Object)id);
        query.setParameter("folderName", (Object)type);
        return query.getResultList();
    }

    public List<PatientUploadedFiles> getImagesByUserId(int id) {
        TypedQuery query = this.em.createQuery("select m from PatientUploadedFiles m JOIN FETCH m.userFiles u where u.id = :id  ", PatientUploadedFiles.class);
        query.setParameter("id", (Object)id);
        return query.getResultList();
    }

    public Long getUserFilesCount(int id) {
        Query query = this.em.createQuery("SELECT COUNT(*) FROM Images m  WHERE m.userId = :id");
        query.setParameter("id", (Object)id);
        return (long)((Long)query.getSingleResult());
    }

    public Images addImagesFles(Images images) {
        return (Images)this.em.merge((Object)images);
    }

    public void deleteImgUploaded(int id) {
        Query query = this.em.createQuery("delete  from PatientUploadedFiles where id = :id  ");
        query.setParameter("id", (Object)id);
        query.executeUpdate();
    }

    public Collection<? extends PatientUploadedFiles> getPatientFilesBYALL(int id, String dateFrom, String dateTo, String ordering, String type) {
        TypedQuery query = this.em.createQuery("select m from PatientUploadedFiles m JOIN FETCH m.userFiles u where u.id = :id AND m.folderName = :type AND m.date BETWEEN :dateFrom AND :dateTo order By m.id DESC ", PatientUploadedFiles.class);
        query.setParameter("id", (Object)id);
        query.setParameter("dateFrom", (Object)dateFrom);
        query.setParameter("dateTo", (Object)dateTo);
        query.setParameter("type", (Object)type);
        return query.getResultList();
    }

    public Collection<? extends PatientUploadedFiles> getPatientFilesByALlAsc(int id, String dateFrom, String dateTo, String ordering, String type) {
        TypedQuery query = this.em.createQuery("select m from PatientUploadedFiles m JOIN FETCH m.userFiles u where u.id = :id AND m.folderName = :type AND m.date BETWEEN :dateFrom AND :dateTo order By m.id ASC ", PatientUploadedFiles.class);
        query.setParameter("id", (Object)id);
        query.setParameter("dateFrom", (Object)dateFrom);
        query.setParameter("dateTo", (Object)dateTo);
        query.setParameter("type", (Object)type);
        return query.getResultList();
    }

    public Object getbloodPressureByDBPdates(int id, String dateFrom, String dateTo) {
        TypedQuery query = this.em.createQuery("select m from BloodPressure m JOIN FETCH m.user u where u.id = :id AND date BETWEEN :dateFrom AND :dateTo", Object.class);
        query.setParameter("id", (Object)id);
        query.setParameter("dateFrom", (Object)dateFrom);
        query.setParameter("dateTo", (Object)dateTo);
        return query.getResultList();
    }

    public Object getHeartRatedates(int id, String dateFrom, String dateTo) {
        TypedQuery query = this.em.createQuery("select m from BloodRate m JOIN FETCH m.user u where u.id = :id AND date BETWEEN :dateFrom AND :dateTo", Object.class);
        query.setParameter("id", (Object)id);
        query.setParameter("dateFrom", (Object)dateFrom);
        query.setParameter("dateTo", (Object)dateTo);
        return query.getResultList();
    }

    public Object getOxygenSaturationdates(int id, String dateFrom, String dateTo) {
        TypedQuery query = this.em.createQuery("select m from OxygenSaturation m JOIN FETCH m.user u where u.id = :id AND date BETWEEN :dateFrom AND :dateTo", Object.class);
        query.setParameter("id", (Object)id);
        query.setParameter("dateFrom", (Object)dateFrom);
        query.setParameter("dateTo", (Object)dateTo);
        return query.getResultList();
    }

    public Object getBloodSugarLeveldates(int id, String dateFrom, String dateTo) {
        TypedQuery query = this.em.createQuery("select m from BloodSugarRandom m JOIN FETCH m.user u where u.id = :id AND date BETWEEN :dateFrom AND :dateTo", Object.class);
        query.setParameter("id", (Object)id);
        query.setParameter("dateFrom", (Object)dateFrom);
        query.setParameter("dateTo", (Object)dateTo);
        return query.getResultList();
    }

    public Object getFluidRangedate(int id, String dateFrom, String dateTo) {
        TypedQuery query = this.em.createQuery("select m from FluidBalance m JOIN FETCH m.user u where u.id = :id AND date BETWEEN :dateFrom AND :dateTo", Object.class);
        query.setParameter("id", (Object)id);
        query.setParameter("dateFrom", (Object)dateFrom);
        query.setParameter("dateTo", (Object)dateTo);
        return query.getResultList();
    }

    public Object getWeightdates(int id, String dateFrom, String dateTo) {
        TypedQuery query = this.em.createQuery("select m from Weight m JOIN FETCH m.user u where u.id = :id AND date BETWEEN :dateFrom AND :dateTo", Object.class);
        query.setParameter("id", (Object)id);
        query.setParameter("dateFrom", (Object)dateFrom);
        query.setParameter("dateTo", (Object)dateTo);
        return query.getResultList();
    }

    public Collection<? extends PatientUploadedFiles> getPatientFilesBYALLNotOrdering(int id, String dateFrom, String dateTo, String ordering, String xrayType) {
        TypedQuery query = this.em.createQuery("select m from PatientUploadedFiles m JOIN FETCH m.userFiles u where u.id = :id  And m.date Between :fromDate AND :toDate AND m.folderName = :type", PatientUploadedFiles.class);
        query.setParameter("id", (Object)id);
        query.setParameter("fromDate", (Object)dateFrom);
        query.setParameter("toDate", (Object)dateTo);
        query.setParameter("type", (Object)xrayType);
        return query.getResultList();
    }

    public PatientUploadedFiles getImagesById(int imagesSaved) {
        TypedQuery query = this.em.createQuery("from PatientUploadedFiles where id =:id ", PatientUploadedFiles.class);
        query.setParameter("id", (Object)imagesSaved);
        return (PatientUploadedFiles)query.getSingleResult();
    }

    public Collection<? extends PatientUploadedFiles> getPatientFilesBYDateOrderingASC(int id, String dateFrom, String dateTo) {
        TypedQuery query = this.em.createQuery("select m from PatientUploadedFiles m JOIN FETCH m.userFiles u where u.id = :userId  AND m.date BETWEEN :dateFrom AND :dateTo order By m.id asc ", PatientUploadedFiles.class);
        query.setParameter("dateFrom", (Object)dateFrom);
        query.setParameter("dateTo", (Object)dateTo);
        query.setParameter("userId", (Object)id);
        return query.getResultList();
    }

    public Collection<? extends PatientUploadedFiles> getPatientFilesBYDateOrderingDESC(int id, String dateFrom, String dateTo) {
        TypedQuery query = this.em.createQuery("select m from PatientUploadedFiles m JOIN FETCH m.userFiles u where u.id = :userId  AND m.date BETWEEN :dateFrom AND :dateTo order By m.id desc ", PatientUploadedFiles.class);
        query.setParameter("dateFrom", (Object)dateFrom);
        query.setParameter("dateTo", (Object)dateTo);
        query.setParameter("userId", (Object)id);
        return query.getResultList();
    }
}

