/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.repository.impl;

import com.example.clinic.model.DoseTime;
import com.example.clinic.model.DoseTimeRenew;
import com.example.clinic.model.LabReports;
import com.example.clinic.model.PatientMedicine;
import com.example.clinic.model.RenewMedicine;
import com.example.clinic.model.Reviews;
import com.example.clinic.model.SavedMidicines;
import com.example.clinic.model.ServiceProfile;
import com.example.clinic.model.ServiceProviders;
import com.example.clinic.repository.PatientMedicineRepository;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@Transactional
public class PatientMedicineRepositoryImpl
implements PatientMedicineRepository {
    @Autowired
    EntityManager em;

    public PatientMedicine addmedicine(PatientMedicine patientMedicine) {
        return (PatientMedicine)this.em.merge((Object)patientMedicine);
    }

    public PatientMedicine findMedicineByid(int id) {
        TypedQuery query = this.em.createQuery("from PatientMedicine where id = :id ", PatientMedicine.class);
        query.setParameter("id", (Object)id);
        return (PatientMedicine)query.getSingleResult();
    }

    public List<PatientMedicine> getMedicinesByUserId(int id) {
        TypedQuery query = this.em.createQuery("select m from PatientMedicine m JOIN FETCH m.userMedicine u where u.id = :id ", PatientMedicine.class);
        query.setParameter("id", (Object)id);
        return query.getResultList();
    }

    public PatientMedicine getMedicineById(int id) {
        TypedQuery query = this.em.createQuery("from PatientMedicine where id = :id ", PatientMedicine.class);
        query.setParameter("id", (Object)id);
        return (PatientMedicine)query.getSingleResult();
    }

    public void deleteMedicine(int id) {
        Query query = this.em.createQuery("delete from  PatientMedicine where id = :id ");
        query.setParameter("id", (Object)id);
        query.executeUpdate();
    }

    public RenewMedicine getMedicineFromRenew(int id) {
        TypedQuery query = this.em.createQuery("from RenewMedicine where medicineId = :id ", RenewMedicine.class);
        query.setParameter("id", (Object)id);
        return (RenewMedicine)query.getSingleResult();
    }

    public void addmedicineRenew(RenewMedicine renewMedicine) {
        this.em.merge((Object)renewMedicine);
    }

    public List<SavedMidicines> savedMidicenes() {
        TypedQuery query = this.em.createQuery("from SavedMidicines   ", SavedMidicines.class);
        return query.getResultList();
    }

    public List<SavedMidicines> savedMidicenesByName(String name) {
        TypedQuery query = this.em.createQuery("from SavedMidicines where name = :name ", SavedMidicines.class);
        query.setParameter("name", (Object)name);
        return query.getResultList();
    }

    public void saveTimes(DoseTime doseTime) {
        this.em.merge((Object)doseTime);
    }

    public void saveTimesRenew(DoseTimeRenew doseTime) {
        this.em.merge((Object)doseTime);
    }

    public LabReports addReport(LabReports report) {
        return (LabReports)this.em.merge((Object)report);
    }

    public void deleteLabReport(int reportId) {
        Query query = this.em.createQuery("delete from  LabReports where id = :id ");
        query.setParameter("id", (Object)reportId);
        query.executeUpdate();
    }

    public List<LabReports> getReportByLabType(String labType, int userId) {
        TypedQuery query = this.em.createQuery("from LabReports l where l.labType = :labType AND l.userReport.id = :userId", LabReports.class);
        query.setParameter("labType", (Object)labType);
        query.setParameter("userId", (Object)userId);
        return query.getResultList();
    }

    public List<LabReports> getByDateFrom(LocalDate dateFrom, int userId) {
        TypedQuery query = this.em.createQuery("from LabReports  l where l.date = :dateFrom AND l.userReport.id = :userId", LabReports.class);
        query.setParameter("dateFrom", (Object)dateFrom);
        query.setParameter("userId", (Object)userId);
        return query.getResultList();
    }

    public List<LabReports> getByDateFromTo(LocalDate dateTo, LocalDate dateFrom, int userId) {
        TypedQuery query = this.em.createQuery("from LabReports l where l.date BETWEEN :dateFrom AND :dateTo AND l.userReport.id = :userId", LabReports.class);
        query.setParameter("dateTo", (Object)dateTo);
        query.setParameter("dateFrom", (Object)dateFrom);
        query.setParameter("userId", (Object)userId);
        return query.getResultList();
    }

    public List<ServiceProviders> getServiceProviders() {
        TypedQuery query = this.em.createQuery("from ServiceProviders  ", ServiceProviders.class);
        return query.getResultList();
    }

    public Collection<? extends ServiceProviders> getServiceProvidersByTypeAndName(String providerName, String providerType) {
        TypedQuery query = this.em.createQuery("from ServiceProviders where serviceType = :providerType  And providerName = :providerName ", ServiceProviders.class);
        query.setParameter("providerType", (Object)providerType);
        query.setParameter("providerName", (Object)providerName);
        return query.getResultList();
    }

    public Collection<? extends ServiceProviders> getServiceProvidersByName(String serviceName) {
        TypedQuery query = this.em.createQuery("from ServiceProviders where   providerName = :providerName ", ServiceProviders.class);
        query.setParameter("providerName", (Object)serviceName);
        return query.getResultList();
    }

    public Collection<? extends ServiceProviders> getServiceProvidersByType(String providerType) {
        TypedQuery query = this.em.createQuery("from ServiceProviders where   serviceType = :providerType ", ServiceProviders.class);
        query.setParameter("providerType", (Object)providerType);
        return query.getResultList();
    }

    public List<ServiceProviders> getServiceProviderByType(String type) {
        TypedQuery query = this.em.createQuery("from ServiceProviders where   serviceType = :type ", ServiceProviders.class);
        query.setParameter("type", (Object)type);
        return query.getResultList();
    }

    public ServiceProfile getDoctorProfile(int doctorId) {
        TypedQuery query = this.em.createQuery("from ServiceProfile where   id = :doctorId ", ServiceProfile.class);
        query.setParameter("doctorId", (Object)doctorId);
        return (ServiceProfile)query.getSingleResult();
    }

    public List<LabReports> getReportsByUSerID(int userId) {
        TypedQuery query = this.em.createQuery("from LabReports l where   l.userReport.id = :doctorId ", LabReports.class);
        query.setParameter("doctorId", (Object)userId);
        return query.getResultList();
    }

    public void addReview(Reviews reviews) {
        this.em.merge((Object)reviews);
    }

    public Collection<? extends ServiceProviders> getServiceNurseBYcity(String serviceType, String city) {
        TypedQuery query = this.em.createQuery("from ServiceProviders where serviceType = :serviceType And providerCity  = :city  ", ServiceProviders.class);
        query.setParameter("serviceType", (Object)serviceType);
        query.setParameter("city", (Object)city);
        return query.getResultList();
    }

    public Collection<? extends ServiceProviders> getServiceNurseBYCountry(String serviceType, String country) {
        TypedQuery query = this.em.createQuery("from ServiceProviders where serviceType = :serviceType And providerCountry  = :country  ", ServiceProviders.class);
        query.setParameter("serviceType", (Object)serviceType);
        query.setParameter("city", (Object)country);
        return query.getResultList();
    }

    public Collection<? extends ServiceProviders> getServiceNurseBYCost(String serviceType, String cost, String costTo) {
        TypedQuery query = this.em.createQuery("from ServiceProviders where serviceType = :serviceType And appointmentCost BETWEEN :cost AND :costTo  ", ServiceProviders.class);
        query.setParameter("serviceType", (Object)serviceType);
        query.setParameter("cost", (Object)cost);
        query.setParameter("costTo", (Object)costTo);
        return query.getResultList();
    }

    public Collection<? extends ServiceProviders> getServiceNurseBYNurseName(String serviceType, String nurseName) {
        TypedQuery query = this.em.createQuery("from ServiceProviders where serviceType = :serviceType AND nurseName = :nurseName  ", ServiceProviders.class);
        query.setParameter("serviceType", (Object)serviceType);
        query.setParameter("nurseName", (Object)nurseName);
        return query.getResultList();
    }

    public Collection<? extends ServiceProviders> getServiceNurseBYRate(String serviceType, int rate) {
        TypedQuery query = this.em.createQuery("from ServiceProviders where serviceType = :serviceType AND rate = :rate  ", ServiceProviders.class);
        query.setParameter("serviceType", (Object)serviceType);
        query.setParameter("rate", (Object)rate);
        return query.getResultList();
    }

    public Collection<? extends ServiceProviders> getServiceBYDoctorName(String serviceType, String doctorName) {
        TypedQuery query = this.em.createQuery("from ServiceProviders where serviceType = :serviceType AND providerName = :doctorName  ", ServiceProviders.class);
        query.setParameter("serviceType", (Object)serviceType);
        query.setParameter("doctorName", (Object)doctorName);
        return query.getResultList();
    }

    public Collection<? extends LabReports> getByLAbALL(String type, LocalDate to, LocalDate from, int id) {
        TypedQuery query = this.em.createQuery("from LabReports l where  l.userReport.id = :userId AND l.date BETWEEN  :dateFrom AND :dateTo   AND l.labType = :type  ", LabReports.class);
        query.setParameter("dateTo", (Object)to);
        query.setParameter("userId", (Object)id);
        query.setParameter("dateFrom", (Object)from);
        query.setParameter("type", (Object)type);
        return query.getResultList();
    }

    public LabReports getReportsByID(int id) {
        TypedQuery query = this.em.createQuery("from LabReports   where id = :id   ", LabReports.class);
        query.setParameter("id", (Object)id);
        return (LabReports)query.getSingleResult();
    }
}

