/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.service;

import com.example.clinic.model.User;
import com.example.clinic.model.UserSession;
import com.example.clinic.repository.UserRepository;
import java.util.Collections;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;

@Service
public class CustomUserDetailsService
implements UserDetailsService {
    @Autowired
    private UserRepository userRepository;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Optional user = this.userRepository.findByemailAddress(username);
        if (user == null) {
            throw new UsernameNotFoundException("User Not Found with username: " + username);
        }
        return new org.springframework.security.core.userdetails.User(((User)user.get()).getEmailAddress(), ((User)user.get()).getPassword(), Collections.emptyList());
    }

    public Optional<UserSession> getTokenByName(String username) throws HttpClientErrorException.Unauthorized {
        Optional token = this.userRepository.gettokenByUserName(username);
        return token;
    }
}

