/*
 * Decompiled with CFR 0.152.
 */
package com.example.clinic.service.impl;

import com.example.clinic.dto.OTPBody;
import com.example.clinic.dto.UserCreateRequest;
import com.example.clinic.dto.VerificationBody;
import com.example.clinic.model.OTPValidation;
import com.example.clinic.model.OnBoarding;
import com.example.clinic.model.User;
import com.example.clinic.repository.UserRepository;
import com.example.clinic.service.RegisterService;
import com.twilio.Twilio;
import com.twilio.rest.verify.v2.service.Verification;
import com.twilio.rest.verify.v2.service.VerificationCheck;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.server.ResponseStatusException;

@Service
public class RegisterServiceImpl
implements RegisterService {
    @Value(value="${twilio.accountSid}")
    String accountSid;
    @Value(value="${twilio.authToken}")
    String authToken;
    @Value(value="${twilio.verifyServiceSid}")
    String verifyServiceSid;
    @Autowired
    UserRepository userRepository;
    private static final String EMAIL_REGEX = "^[A-Za-z0-9+_.-]+@[A-Za-z0-9.-]+$";
    private static final Pattern pattern = Pattern.compile("^[A-Za-z0-9+_.-]+@[A-Za-z0-9.-]+$");
    private static final String patternNumbers = "^[0-9]+$";
    private static final Pattern patternNumberMatcher = Pattern.compile("^[0-9]+$");

    public User addUser(UserCreateRequest userCreateRequest) {
        User user = new User();
        Optional student = this.userRepository.findByUsername(userCreateRequest.getEmailAddress());
        if (!ObjectUtils.isEmpty((Object)student)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "already exist user");
        }
        if (userCreateRequest.getAddress() == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Address IS Required");
        }
        user.setAddress(userCreateRequest.getAddress());
        if (userCreateRequest.getFirstName() == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Firstname IS Required");
        }
        user.setFirstName(userCreateRequest.getFirstName());
        if (userCreateRequest.getLastName() != null) {
            user.setLastName(userCreateRequest.getLastName());
        }
        if (userCreateRequest.getEmailAddress() != null) {
            Matcher matcher = pattern.matcher(userCreateRequest.getEmailAddress());
            if (!matcher.matches()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Email format IS not Valid");
            }
        } else {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Email IS Required");
        }
        user.setEmailAddress(userCreateRequest.getEmailAddress());
        if (userCreateRequest.getPassword() == null || userCreateRequest.getPassword().length() < 8) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Password IS Required or length less than  8 digits");
        }
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        user.setPassword(passwordEncoder.encode((CharSequence)userCreateRequest.getPassword()));
        if (userCreateRequest.getTelephoneNumber() != null) {
            Matcher matcherNumber = patternNumberMatcher.matcher(userCreateRequest.getTelephoneNumber());
            if (!matcherNumber.matches()) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "TelePhone number IS Not Valid");
            }
        } else {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "TelePhone number IS Required");
        }
        user.setTelephoneNumber(userCreateRequest.getTelephoneNumber());
        return this.userRepository.registerUser(user);
    }

    public void sendOtp(String phoneNumber) {
        Twilio.init((String)this.accountSid, (String)this.authToken);
        Verification.creator((String)this.verifyServiceSid, (String)phoneNumber, (String)"sms").create();
    }

    public boolean verifyOtp(VerificationBody verificationBody) {
        Twilio.init((String)this.accountSid, (String)this.authToken);
        VerificationCheck verificationCheck = (VerificationCheck)VerificationCheck.creator((String)this.verifyServiceSid).setTo(verificationBody.getPhoneNumber()).setCode(verificationBody.getOtp()).create();
        User user = (User)this.userRepository.getUserByPhone(verificationBody.getPhoneNumber()).get();
        user.setVerified(true);
        this.userRepository.registerUser(user);
        return verificationCheck.getStatus().equals("approved");
    }

    public List<OnBoarding> getOnBoard() {
        List onBoardings = this.userRepository.getOnboardingView();
        if (!onBoardings.isEmpty()) {
            return onBoardings;
        }
        return new ArrayList<OnBoarding>();
    }

    public OTPValidation verifyOTPEditPassword(OTPBody otpBody) {
        Optional otpValidation = this.userRepository.getOtpByEmail(otpBody.getEmail());
        if (!otpValidation.isPresent()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "this OTP IS not Valid");
        }
        if (!((OTPValidation)otpValidation.get()).getOtp().equals(otpBody.getOtp())) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "this OTP IS not Valid");
        }
        Timestamp timeStamp = ((OTPValidation)otpValidation.get()).getCreatedAt();
        String splittedTime = timeStamp.toString().split(" ")[1];
        LocalDateTime currentDateTime = LocalDateTime.now();
        String[] timeArray = splittedTime.split(":");
        int hour = Integer.parseInt(timeArray[0]);
        int minute = Integer.parseInt(timeArray[1]);
        int second = Integer.parseInt(timeArray[2].split("\\.")[0]);
        int secondCurrent = Integer.parseInt(currentDateTime.toString().split("T")[1].split(":")[2].split("\\.")[0]);
        int toalDuration = Math.abs(secondCurrent - second);
        if (minute == currentDateTime.getMinute() && toalDuration >= 58) {
            this.userRepository.deleteValidatedOTP(otpBody.getEmail());
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "this OTP IS Expired");
        }
        if (minute < currentDateTime.getMinute() && toalDuration >= 58) {
            this.userRepository.deleteValidatedOTP(otpBody.getEmail());
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "this OTP IS Expired");
        }
        User user = this.userRepository.getUserByEmail(otpBody.getEmail());
        user.setEmailVerified(true);
        this.userRepository.registerUser(user);
        this.userRepository.deleteValidatedOTP(otpBody.getEmail());
        return otpValidation.orElse(null);
    }

    public void editPassword(OTPBody otpBody) {
        Optional user = this.userRepository.findByemailAddress(otpBody.getEmail());
        if (!user.isPresent()) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, " the email is not registered");
        }
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        String password = encoder.encode((CharSequence)otpBody.getPassword());
        ((User)user.get()).setPassword(password);
        this.userRepository.saveEdittedUser((User)user.get());
    }

    public Object getProfileofUser(int userId) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return this.userRepository.findById(userId).get();
    }
}

